<?php
/**
* JoomlaWatch - A real-time ajax joomla monitor and live stats
* @version 1.2.0
* @package JoomlaWatch
* @license http://www.gnu.org/licenses/gpl-3.0.txt 	GNU General Public License v3
* @copyright (C) 2007 by Matej Koval - All rights reserved! 
* @website http://www.codegravity.com
**/


define('_VALID_MOS', 1);

require_once ('../../globals.php');
require_once ('../../configuration.php');
require_once ('../../includes/joomla.php');
require_once ("../../language/english.php");

require_once ("../../components/com_joomlawatch/config.php");
require_once ("../../components/com_joomlawatch/class.joomlawatch.php");
require_once ("../../components/com_joomlawatch/class.joomlawatch.html.php");
require_once ("../../components/com_joomlawatch/class.ip2country.php");

if (!JoomlaWatch :: checkPermissions()) 
	die("You don't have any permissions to view this !");


$t1 = (time()+microtime());

$query = "select id from #__joomlawatch order by id desc limit 1";
$database->setQuery($query);
$rows = $database->loadObjectList();
$row = @ $rows[0];

$last = @ $row->id;

$params = new MosParameters("");
$today = floor(time()/24/3600);
$thisWeek = ceil(time()/24/3600/7);
if (@ $_GET['day']) $day = @ $_GET['day']; else 
		$day=floor(time()/24/3600); 

if (@ $_GET['week']) $week = @ $_GET['week']; else 
	$week=ceil(time()/24/3600/7);

$prev = $day-1;
$next = $day+1;
$prevWeek = $week-1;
$nextWeek = $week+1;

?>

<table border='0' cellpadding='1' cellspacing='0'>

<tr><td colspan='5'><h3>Visit stats</h3></td></tr>
<tr><td align='left'><?php echo("<a href='javascript:setWeek($prevWeek)' id='visits_$prevWeek'>&lt;Week ".date("W",$prevWeek*3600*24*7)."<img src='$mosConfig_live_site/components/com_joomlawatch/icons/calendar.gif' border='0' align='center' /></a>"); ?></td>
<td align='center'><?php if (@$week != $thisWeek)echo("<a href='javascript:setWeek($thisWeek)' id='visits_$thisWeek'>this week</a>"); ?></td>
<td align='right'><?php if ($nextWeek <= $thisWeek) echo("<a href='javascript:setWeek($nextWeek)' id='visits_$nextWeek'><img src='$mosConfig_live_site/components/com_joomlawatch/icons/calendar.gif' border='0' align='center' />Week ".date("W",$nextWeek*3600*24*7)."&gt;</a>"); ?></td>
</tr>
<tr><td>
</td>
<?php echo JoomlaWatchHTML :: renderVisitsGraph($week); ?>
<br/>


<tr><td colspan='3'>
<table><tr><td align='center' class='<?php echo JoomlaWatchHTML :: renderTabClass(!@$_GET['alltime']);?>'>
<?php echo JoomlaWatchHTML :: renderSwitched("daily","Daily stats",@$_GET['alltime']); ?>
</td>
<td align='center'  class='<?php echo JoomlaWatchHTML :: renderTabClass(@$_GET['alltime']);?>'> 
<?php echo JoomlaWatchHTML :: renderSwitched("alltime","All-time stats",!@$_GET['alltime']); ?>
</td>
<td align='center'  class='tab_none'> 
</td>
</tr></table>
<?php if (@$_GET['alltime'] == true) { ?>
<tr><td colspan='5'><h3>All-time stats</h3></td>

<tr><td colspan='3'><u>All-time URI</u></td></tr>
<tr><td><?php echo JoomlaWatchHTML :: renderExpand("uri"); ?></td></tr>
<tr><td  valign='top'><?php echo JoomlaWatchHTML :: renderTotalIntValuesByName("uri", @$_GET['uri']); ?></td></tr>
<tr><td colspan='3'>&nbsp;</td></tr>
<tr><td colspan='3'><u>All-time Countries</u></td></tr>
<tr><td><?php echo JoomlaWatchHTML :: renderExpand("countries"); ?></td></tr>
<tr><td valign='top'><?php echo JoomlaWatchHTML :: renderTotalIntValuesByName("country", @$_GET['countries']); ?></td></tr>
<tr><td colspan='3'>&nbsp;</td></tr>
<tr><td colspan='3'><u>All-time Browsers</u></td></tr>
<tr><td><?php echo JoomlaWatchHTML :: renderExpand("browsers"); ?></td></tr>
<tr><td valign='top'><?php echo JoomlaWatchHTML :: renderTotalIntValuesByName("browser", @$_GET['browsers']); ?></td></tr>
<tr><td colspan='3'>&nbsp;</td></tr>
<tr><td colspan='3'><u>All-time OS</u></td></tr>
<tr><td><?php echo JoomlaWatchHTML :: renderExpand("os"); ?></td></tr>
<tr><td valign='top'><?php echo JoomlaWatchHTML :: renderTotalIntValuesByName("os", @$_GET['os']); ?></td></tr>
<?php } else { ?>
	
<h3>Daily stats <?php echo JoomlaWatchHTML :: getDateByDay($day);?></h3>
<table width='100%'>
<tr><td align='left'><?php echo("<a href='javascript:setDay($prev)' id='$prev'>&lt;".date("d.m.Y",$prev*3600*24)."<img src='$mosConfig_live_site/components/com_joomlawatch/icons/calendar.gif' border='0' align='center' /></a>"); ?></td>
<td align='center'><?php if ($day != $today)echo("<a href='javascript:setDay($today)' id='$today'>today</a>"); ?></td>
<td align='right'><?php if ($next <= $today) echo("<a href='javascript:setDay($next)' id='$next'><img src='$mosConfig_live_site/components/com_joomlawatch/icons/calendar.gif' border='0' align='center' />".date("d.m.Y",$next*3600*24)."&gt;</a>"); ?></td>
</tr>
</table>
</td></tr>

<tr><td colspan='3'><u>URI for <?php echo JoomlaWatchHTML :: getDateByDay($day);?></u></td></tr>
<tr><td><?php echo JoomlaWatchHTML :: renderExpand("uri"); ?></td></tr>
<tr><td  valign='top'><?php echo JoomlaWatchHTML :: renderIntValuesByName("uri", $day, @$_GET['uri']); ?></td></tr>
<tr><td colspan='3'>&nbsp;</td></tr>
<tr><td colspan='3'><u>Countries for <?php echo JoomlaWatchHTML :: getDateByDay($day);?></u></td></tr>
<tr><td><?php echo JoomlaWatchHTML :: renderExpand("countries"); ?></td></tr>
<tr><td><?php echo JoomlaWatchHTML :: renderIntValuesByName("country", $day, @$_GET['countries']); ?></td></tr>
<tr><td colspan='3'>&nbsp;</td></tr>
<tr><td colspan='3'><u>Browsers for <?php echo JoomlaWatchHTML :: getDateByDay($day);?></u></td></tr>
<tr><td><?php echo JoomlaWatchHTML :: renderExpand("browser"); ?></td></tr>
<tr><td valign='top'><?php echo JoomlaWatchHTML :: renderIntValuesByName("browser", $day, @$_GET['browser']); ?></td></tr>
<tr><td colspan='3'>&nbsp;</td></tr>
<tr><td colspan='3'><u>OS for <?php echo JoomlaWatchHTML :: getDateByDay($day);?></u></td></tr>
<tr><td><?php echo JoomlaWatchHTML :: renderExpand("os"); ?></td></tr>
<tr><td valign='top'><?php echo JoomlaWatchHTML :: renderIntValuesByName("os", $day, @$_GET['os']); ?></td></tr>
<tr><td colspan='3'>&nbsp;</td></tr>
<?php } ?>

</table>

<!-- rendered in <?php echo((time()+microtime())-$t1); ?>s -->

