
DROP TABLE IF EXISTS `jos_joomlawatch`;
CREATE TABLE `jos_joomlawatch` (
  `id` int auto_increment primary key,
  `ip` varchar(255) default NULL,
  `country` varchar(2) default NULL,
  `browser` varchar(255) default NULL
);

alter table `jos_joomlawatch` add INDEX (`ip`);
alter table `jos_joomlawatch` add INDEX (`browser`);


DROP TABLE IF EXISTS `jos_joomlawatch_helper`;
CREATE TABLE `jos_joomlawatch_helper` (
  `id` int auto_increment primary key,
  `date` varchar(255) default NULL,
  `name` varchar(255) default NULL,
  `value` int default NULL,
  KEY `name` (`name`)
);


DROP TABLE IF EXISTS `jos_joomlawatch_info`;
CREATE TABLE `jos_joomlawatch_info` (
  `id` int auto_increment primary key,
  `group` varchar(255) default NULL,
  `date` varchar(255) default NULL,
  `name` varchar(255) default NULL,
  `value` int default NULL
);

alter table `jos_joomlawatch_info` add INDEX (`group`);
alter table `jos_joomlawatch_info` add INDEX (`name`);
alter table `jos_joomlawatch_info` add INDEX (`date`);


DROP TABLE IF EXISTS `jos_joomlawatch_ip2c`;
CREATE TABLE `jos_joomlawatch_ip2c` (
  `start` int(10) unsigned NOT NULL default '0',
  `end` int(10) unsigned NOT NULL default '0',
  `a2` char(2) NOT NULL default '',
  `a3` char(3) NOT NULL default '',
  `country` varchar(100) NOT NULL default ''
);
alter table `jos_joomlawatch_ip2c` add PRIMARY KEY  (`start`,`end`);

DROP TABLE IF EXISTS `jos_joomlawatch_uri`;
CREATE TABLE `jos_joomlawatch_uri` (
  `id` int auto_increment primary key,
  `fk` int default NULL,
  `timestamp` int default NULL,
  `uri` varchar(255) default NULL,
  `title` varchar(255) default NULL
);

ALTER TABLE `jos_joomlawatch_uri` ADD INDEX ( `timestamp` );

